/**
 * Useful generic tools.
 * @module utils
 */
window.O.Utils || (window.O.Utils = {});

/**
 * Date utilities.
 * @class Date
 * @static
 */
O.Utils.Date = {
    /**
	 * time formatting 
	 * @method formatTime
	 * @param {timestamp} d
	 * @returns {String} with formatted date
	 * */
	formatTime: function(d){
		
		var date = new Date(),
			diff = ((date.getTime() - d) / 1000),
			day_diff = Math.floor(diff / 86400);
			
		if ( isNaN(day_diff) || day_diff < 0  )
			return '';
			
		return day_diff == 0 && 
			( 
					diff < 60 && "just now" ||
					diff < 120 && "1 minute ago" ||
					diff < 3600 && Math.floor( diff / 60 ) + " minutes ago" ||
					diff < 7200 && "1 hour ago" ||
					diff < 86400 && Math.floor( diff / 3600 ) + " hours ago"
			)||
			
			day_diff == 1 && "Yesterday" ||
			day_diff < 7 && day_diff + " days ago" ||
			day_diff < 31 && Math.ceil( day_diff / 7 ) + " weeks ago" || 
			day_diff >= 31 && "few months ago";
	}
};

